<?php
include 'conexao.php';
require 'envia_email.php';

$id = $_GET['id'] ?? 0;

$sql = "SELECT c.id, cl.nome, cl.email, cl.whatsapp, sv.nome AS servico, sv.valor, c.data, c.observacoes
        FROM contas c
        JOIN clientes cl ON c.cliente_id = cl.id
        JOIN servicos sv ON c.servico_id = sv.id
        WHERE c.id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$id]);
$conta = $stmt->fetch();

if (!$conta) {
    die("Conta não encontrada.");
}

$pdfPath = gerarPDFConta(
    $conta['nome'],
    $conta['email'],
    $conta['whatsapp'],
    $conta['servico'],
    number_format($conta['valor'], 2, ',', '.'),
    $conta['data'],
    nl2br($conta['observacoes']),
    $conta['id']
);

$linkWhatsApp = "https://wa.me/55{$conta['whatsapp']}?text=" . urlencode("Olá {$conta['nome']}, segue sua cobrança: {$conta['servico']} - R$ {$conta['valor']} em {$conta['data']}.");

if (enviarEmailContaComPDF(
    $conta['email'],
    $conta['nome'],
    $conta['servico'],
    number_format($conta['valor'], 2, ',', '.'),
    $conta['data'],
    nl2br($conta['observacoes']),
    $linkWhatsApp,
    $pdfPath
)) {
    $pdo->prepare("INSERT INTO envios (conta_id) VALUES (?)")->execute([$conta['id']]);
    echo "<script>alert('Conta reenviada com sucesso!'); window.location.href='envios.php';</script>";
} else {
    echo "<script>alert('Erro ao reenviar a conta.'); window.location.href='envios.php';</script>";
}
?>
