<?php include 'menu.php'; include 'conexao.php'; ?>
<h2>Relatório de Contas Emitidas</h2>
<form method="GET" class="row g-3 mb-4">
  <div class="col-md-4">
    <label>Cliente</label>
    <select name="cliente_id" class="form-select">
      <option value="">Todos</option>
      <?php
      foreach ($pdo->query("SELECT id, nome FROM clientes ORDER BY nome") as $cli) {
          $sel = ($_GET['cliente_id'] ?? '') == $cli['id'] ? 'selected' : '';
          echo "<option value='{$cli['id']}' $sel>{$cli['nome']}</option>";
      }
      ?>
    </select>
  </div>
  <div class="col-md-3">
    <label>Data Inicial</label>
    <input type="date" name="data_ini" class="form-control" value="<?= $_GET['data_ini'] ?? '' ?>">
  </div>
  <div class="col-md-3">
    <label>Data Final</label>
    <input type="date" name="data_fim" class="form-control" value="<?= $_GET['data_fim'] ?? '' ?>">
  </div>
  <div class="col-md-2">
    <label>&nbsp;</label>
    <button class="btn btn-primary w-100" type="submit">Filtrar</button>
  </div>
</form>

<table class="table table-bordered">
  <thead>
    <tr>
      <th>Conta</th>
      <th>Cliente</th>
      <th>Serviço</th>
      <th>Valor</th>
      <th>Data</th>
    </tr>
  </thead>
  <tbody>
<?php
$where = [];
$params = [];

if (!empty($_GET['cliente_id'])) {
    $where[] = "c.cliente_id = ?";
    $params[] = $_GET['cliente_id'];
}
if (!empty($_GET['data_ini'])) {
    $where[] = "c.data >= ?";
    $params[] = $_GET['data_ini'];
}
if (!empty($_GET['data_fim'])) {
    $where[] = "c.data <= ?";
    $params[] = $_GET['data_fim'];
}

$whereSQL = $where ? 'WHERE ' . implode(' AND ', $where) : '';

$sql = "SELECT c.id, cl.nome AS cliente, sv.nome AS servico, sv.valor, c.data
        FROM contas c
        JOIN clientes cl ON c.cliente_id = cl.id
        JOIN servicos sv ON c.servico_id = sv.id
        $whereSQL
        ORDER BY c.data DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);

$total = 0;
while ($row = $stmt->fetch()) {
    echo "<tr>
            <td>#{$row['id']}</td>
            <td>{$row['cliente']}</td>
            <td>{$row['servico']}</td>
            <td>R$ " . number_format($row['valor'], 2, ',', '.') . "</td>
            <td>" . date('d/m/Y', strtotime($row['data'])) . "</td>
          </tr>";
    $total += $row['valor'];
}
?>
  </tbody>
  <tfoot>
    <tr>
      <th colspan="3" class="text-end">Total</th>
      <th colspan="2">R$ <?= number_format($total, 2, ',', '.') ?></th>
    </tr>
  </tfoot>
</table>
<?php include 'footer.php'; ?>
